// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> The MessageDetails. </summary>
    public partial class MessageDetails
    {
        /// <summary> Initializes a new instance of <see cref="MessageDetails"/>. </summary>
        public MessageDetails()
        {
            SupportedProtocols = new ChangeTrackingList<MessageProtocol>();
            UseCases = new ChangeTrackingList<UseCase>();
        }

        /// <summary> Initializes a new instance of <see cref="MessageDetails"/>. </summary>
        /// <param name="supportedProtocols"> Applicable message protocols used in the program e.g. SMS, MMS. </param>
        /// <param name="recurrence"> Indicates the nature of the messaging associated with the program e.g. 'subscription', 'transaction'. </param>
        /// <param name="helpMessage">
        /// Message text for mobile terminated message associated with HELP keyword
        /// e.g 'This is the HELP message test.'.
        /// </param>
        /// <param name="optOutMessage">
        /// "Message text for mobile terminated message associated with STOP keyword
        /// e.g. 'This is the STOP message test.'.
        /// </param>
        /// <param name="optInMessage"> OptInMessage. </param>
        /// <param name="optInReply"> Keyword used to confirm double Opt-In method e.g. 'JOIN'. </param>
        /// <param name="confirmationMessage"> ConfirmationMessage. </param>
        /// <param name="directionality"> Describes directionality e.g. oneWay or twoWay. </param>
        /// <param name="useCases"> Provides message exchange examples from and to end user for each supported message content type. </param>
        internal MessageDetails(IList<MessageProtocol> supportedProtocols, MessageRecurrence? recurrence, string helpMessage, string optOutMessage, string optInMessage, string optInReply, string confirmationMessage, MessageDirectionality? directionality, IList<UseCase> useCases)
        {
            SupportedProtocols = supportedProtocols;
            Recurrence = recurrence;
            HelpMessage = helpMessage;
            OptOutMessage = optOutMessage;
            OptInMessage = optInMessage;
            OptInReply = optInReply;
            ConfirmationMessage = confirmationMessage;
            Directionality = directionality;
            UseCases = useCases;
        }

        /// <summary> Applicable message protocols used in the program e.g. SMS, MMS. </summary>
        public IList<MessageProtocol> SupportedProtocols { get; }
        /// <summary> Indicates the nature of the messaging associated with the program e.g. 'subscription', 'transaction'. </summary>
        public MessageRecurrence? Recurrence { get; set; }
        /// <summary>
        /// Message text for mobile terminated message associated with HELP keyword
        /// e.g 'This is the HELP message test.'.
        /// </summary>
        public string HelpMessage { get; set; }
        /// <summary>
        /// "Message text for mobile terminated message associated with STOP keyword
        /// e.g. 'This is the STOP message test.'.
        /// </summary>
        public string OptOutMessage { get; set; }
        /// <summary> OptInMessage. </summary>
        public string OptInMessage { get; set; }
        /// <summary> Keyword used to confirm double Opt-In method e.g. 'JOIN'. </summary>
        public string OptInReply { get; set; }
        /// <summary> ConfirmationMessage. </summary>
        public string ConfirmationMessage { get; set; }
        /// <summary> Describes directionality e.g. oneWay or twoWay. </summary>
        public MessageDirectionality? Directionality { get; set; }
        /// <summary> Provides message exchange examples from and to end user for each supported message content type. </summary>
        public IList<UseCase> UseCases { get; }
    }
}
