// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Indicates the messaging content category used in the program e.g. 'ringTones', 'smsChat', 'video', 'loyaltyProgramPointsPrizes', 'gifting', 'inApplicationBilling', 'textToScreen'. </summary>
    public readonly partial struct MessageContentCategory : IEquatable<MessageContentCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageContentCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageContentCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RingTonesValue = "ringTones";
        private const string SmsChatValue = "smsChat";
        private const string VideoValue = "video";
        private const string LoyaltyProgramPointsPrizesValue = "loyaltyProgramPointsPrizes";
        private const string GiftingValue = "gifting";
        private const string InApplicationBillingValue = "inApplicationBilling";
        private const string TextToScreenValue = "textToScreen";
        private const string GamesValue = "games";
        private const string AudioChatValue = "audioChat";
        private const string MmsPicturesValue = "mmsPictures";
        private const string SweepstakesContestAuctionValue = "sweepstakesContestAuction";
        private const string FinancialBankingValue = "financialBanking";
        private const string PremiumWapValue = "premiumWap";
        private const string QueryServiceValue = "queryService";
        private const string WallpaperScreensaverValue = "wallpaperScreensaver";
        private const string VotingValue = "voting";
        private const string ApplicationValue = "application";
        private const string MobileGivingDonationsValue = "mobileGivingDonations";
        private const string CouponsValue = "coupons";
        private const string LoyaltyProgramValue = "loyaltyProgram";
        private const string NoPointsPrizesValue = "noPointsPrizes";
        private const string InformationalAlertsValue = "informationalAlerts";
        private const string MicroBillingValue = "microBilling";
        private const string TriviaValue = "trivia";
        private const string EntertainmentAlertsValue = "entertainmentAlerts";
        private const string AccountNotificationValue = "accountNotification";
        private const string AgeGatedContentValue = "ageGatedContent";
        private const string ConversationalMessagingValue = "conversationalMessaging";
        private const string DeliveryNotificationValue = "deliveryNotification";
        private const string EducationValue = "education";
        private const string EmergencyAlertsValue = "emergencyAlerts";
        private const string FraudAlertsValue = "fraudAlerts";
        private const string LoanArrangementValue = "loanArrangement";
        private const string OnBehalfOfCarrierValue = "onBehalfOfCarrier";
        private const string PoliticalValue = "political";
        private const string PromotionalMarketingValue = "promotionalMarketing";
        private const string PublicServiceAnnouncementsValue = "publicServiceAnnouncements";
        private const string SecurityAlertsValue = "securityAlerts";
        private const string SocialMediaValue = "socialMedia";
        private const string TwoFactorAuthenticationValue = "twoFactorAuthentication";
        private const string OtherValue = "other";

        /// <summary> ringTones. </summary>
        public static MessageContentCategory RingTones { get; } = new MessageContentCategory(RingTonesValue);
        /// <summary> smsChat. </summary>
        public static MessageContentCategory SmsChat { get; } = new MessageContentCategory(SmsChatValue);
        /// <summary> video. </summary>
        public static MessageContentCategory Video { get; } = new MessageContentCategory(VideoValue);
        /// <summary> loyaltyProgramPointsPrizes. </summary>
        public static MessageContentCategory LoyaltyProgramPointsPrizes { get; } = new MessageContentCategory(LoyaltyProgramPointsPrizesValue);
        /// <summary> gifting. </summary>
        public static MessageContentCategory Gifting { get; } = new MessageContentCategory(GiftingValue);
        /// <summary> inApplicationBilling. </summary>
        public static MessageContentCategory InApplicationBilling { get; } = new MessageContentCategory(InApplicationBillingValue);
        /// <summary> textToScreen. </summary>
        public static MessageContentCategory TextToScreen { get; } = new MessageContentCategory(TextToScreenValue);
        /// <summary> games. </summary>
        public static MessageContentCategory Games { get; } = new MessageContentCategory(GamesValue);
        /// <summary> audioChat. </summary>
        public static MessageContentCategory AudioChat { get; } = new MessageContentCategory(AudioChatValue);
        /// <summary> mmsPictures. </summary>
        public static MessageContentCategory MmsPictures { get; } = new MessageContentCategory(MmsPicturesValue);
        /// <summary> sweepstakesContestAuction. </summary>
        public static MessageContentCategory SweepstakesContestAuction { get; } = new MessageContentCategory(SweepstakesContestAuctionValue);
        /// <summary> financialBanking. </summary>
        public static MessageContentCategory FinancialBanking { get; } = new MessageContentCategory(FinancialBankingValue);
        /// <summary> premiumWap. </summary>
        public static MessageContentCategory PremiumWap { get; } = new MessageContentCategory(PremiumWapValue);
        /// <summary> queryService. </summary>
        public static MessageContentCategory QueryService { get; } = new MessageContentCategory(QueryServiceValue);
        /// <summary> wallpaperScreensaver. </summary>
        public static MessageContentCategory WallpaperScreensaver { get; } = new MessageContentCategory(WallpaperScreensaverValue);
        /// <summary> voting. </summary>
        public static MessageContentCategory Voting { get; } = new MessageContentCategory(VotingValue);
        /// <summary> application. </summary>
        public static MessageContentCategory Application { get; } = new MessageContentCategory(ApplicationValue);
        /// <summary> mobileGivingDonations. </summary>
        public static MessageContentCategory MobileGivingDonations { get; } = new MessageContentCategory(MobileGivingDonationsValue);
        /// <summary> coupons. </summary>
        public static MessageContentCategory Coupons { get; } = new MessageContentCategory(CouponsValue);
        /// <summary> loyaltyProgram. </summary>
        public static MessageContentCategory LoyaltyProgram { get; } = new MessageContentCategory(LoyaltyProgramValue);
        /// <summary> noPointsPrizes. </summary>
        public static MessageContentCategory NoPointsPrizes { get; } = new MessageContentCategory(NoPointsPrizesValue);
        /// <summary> informationalAlerts. </summary>
        public static MessageContentCategory InformationalAlerts { get; } = new MessageContentCategory(InformationalAlertsValue);
        /// <summary> microBilling. </summary>
        public static MessageContentCategory MicroBilling { get; } = new MessageContentCategory(MicroBillingValue);
        /// <summary> trivia. </summary>
        public static MessageContentCategory Trivia { get; } = new MessageContentCategory(TriviaValue);
        /// <summary> entertainmentAlerts. </summary>
        public static MessageContentCategory EntertainmentAlerts { get; } = new MessageContentCategory(EntertainmentAlertsValue);
        /// <summary> accountNotification. </summary>
        public static MessageContentCategory AccountNotification { get; } = new MessageContentCategory(AccountNotificationValue);
        /// <summary> ageGatedContent. </summary>
        public static MessageContentCategory AgeGatedContent { get; } = new MessageContentCategory(AgeGatedContentValue);
        /// <summary> conversationalMessaging. </summary>
        public static MessageContentCategory ConversationalMessaging { get; } = new MessageContentCategory(ConversationalMessagingValue);
        /// <summary> deliveryNotification. </summary>
        public static MessageContentCategory DeliveryNotification { get; } = new MessageContentCategory(DeliveryNotificationValue);
        /// <summary> education. </summary>
        public static MessageContentCategory Education { get; } = new MessageContentCategory(EducationValue);
        /// <summary> emergencyAlerts. </summary>
        public static MessageContentCategory EmergencyAlerts { get; } = new MessageContentCategory(EmergencyAlertsValue);
        /// <summary> fraudAlerts. </summary>
        public static MessageContentCategory FraudAlerts { get; } = new MessageContentCategory(FraudAlertsValue);
        /// <summary> loanArrangement. </summary>
        public static MessageContentCategory LoanArrangement { get; } = new MessageContentCategory(LoanArrangementValue);
        /// <summary> onBehalfOfCarrier. </summary>
        public static MessageContentCategory OnBehalfOfCarrier { get; } = new MessageContentCategory(OnBehalfOfCarrierValue);
        /// <summary> political. </summary>
        public static MessageContentCategory Political { get; } = new MessageContentCategory(PoliticalValue);
        /// <summary> promotionalMarketing. </summary>
        public static MessageContentCategory PromotionalMarketing { get; } = new MessageContentCategory(PromotionalMarketingValue);
        /// <summary> publicServiceAnnouncements. </summary>
        public static MessageContentCategory PublicServiceAnnouncements { get; } = new MessageContentCategory(PublicServiceAnnouncementsValue);
        /// <summary> securityAlerts. </summary>
        public static MessageContentCategory SecurityAlerts { get; } = new MessageContentCategory(SecurityAlertsValue);
        /// <summary> socialMedia. </summary>
        public static MessageContentCategory SocialMedia { get; } = new MessageContentCategory(SocialMediaValue);
        /// <summary> twoFactorAuthentication. </summary>
        public static MessageContentCategory TwoFactorAuthentication { get; } = new MessageContentCategory(TwoFactorAuthenticationValue);
        /// <summary> other. </summary>
        public static MessageContentCategory Other { get; } = new MessageContentCategory(OtherValue);
        /// <summary> Determines if two <see cref="MessageContentCategory"/> values are the same. </summary>
        public static bool operator ==(MessageContentCategory left, MessageContentCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageContentCategory"/> values are not the same. </summary>
        public static bool operator !=(MessageContentCategory left, MessageContentCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageContentCategory"/>. </summary>
        public static implicit operator MessageContentCategory(string value) => new MessageContentCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageContentCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageContentCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
