// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Contact Information. </summary>
    public partial class ContactInformation
    {
        /// <summary> Initializes a new instance of <see cref="ContactInformation"/>. </summary>
        public ContactInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContactInformation"/>. </summary>
        /// <param name="name"> Name of authorized user for purposes of submitting the Program Brief. </param>
        /// <param name="phone"> Contact phone number for the authorized user for the customer. Use E164 format. e.g. +14086111111. </param>
        /// <param name="email"> Contact email address number for the authorized user for the customer. </param>
        internal ContactInformation(string name, string phone, string email)
        {
            Name = name;
            Phone = phone;
            Email = email;
        }

        /// <summary> Name of authorized user for purposes of submitting the Program Brief. </summary>
        public string Name { get; set; }
        /// <summary> Contact phone number for the authorized user for the customer. Use E164 format. e.g. +14086111111. </summary>
        public string Phone { get; set; }
        /// <summary> Contact email address number for the authorized user for the customer. </summary>
        public string Email { get; set; }
    }
}
