// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> The CompanyInformation. </summary>
    public partial class CompanyInformation
    {
        /// <summary> Initializes a new instance of <see cref="CompanyInformation"/>. </summary>
        public CompanyInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CompanyInformation"/>. </summary>
        /// <param name="name"> Legal entity name for customer submitting Program Brief. </param>
        /// <param name="url"> Company URL for customer submitting Program Brief. </param>
        /// <param name="address"> Company's address for the customer submitting the Program Brief. </param>
        /// <param name="contactInformation"> Contact Information. </param>
        /// <param name="customerCareInformation"> Customer Care Information. </param>
        internal CompanyInformation(string name, Uri url, string address, ContactInformation contactInformation, CustomerCareInformation customerCareInformation)
        {
            Name = name;
            Url = url;
            Address = address;
            ContactInformation = contactInformation;
            CustomerCareInformation = customerCareInformation;
        }

        /// <summary> Legal entity name for customer submitting Program Brief. </summary>
        public string Name { get; set; }
        /// <summary> Company URL for customer submitting Program Brief. </summary>
        public Uri Url { get; set; }
        /// <summary> Company's address for the customer submitting the Program Brief. </summary>
        public string Address { get; set; }
        /// <summary> Contact Information. </summary>
        public ContactInformation ContactInformation { get; set; }
        /// <summary> Customer Care Information. </summary>
        public CustomerCareInformation CustomerCareInformation { get; set; }
    }
}
