// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class CommunicationShortCodesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ShortCode"/>. </summary>
        /// <param name="number"> The value of the ShortCode or the alpha numeric e.g. '555555', 'CONTOSO', etc. </param>
        /// <param name="numberType"> The type of number e.g. 'ShortCode', 'AlphaId'. </param>
        /// <param name="countryCode"> ISO 3166 2-char code representing the country e.g. 'US'. </param>
        /// <param name="programBriefIds"> Program Brief Name. </param>
        /// <param name="purchaseDate"> Date in which number was purchased. </param>
        /// <returns> A new <see cref="Models.ShortCode"/> instance for mocking. </returns>
        public static ShortCode ShortCode(string number = null, NumberType? numberType = null, string countryCode = null, IEnumerable<string> programBriefIds = null, DateTimeOffset? purchaseDate = null)
        {
            programBriefIds ??= new List<string>();

            return new ShortCode(number, numberType, countryCode, programBriefIds?.ToList(), purchaseDate);
        }
    }
}
