// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Rooms
{
    /// <summary> Request payload for updating a room. </summary>
    internal partial class UpdateRoomRequest
    {
        /// <summary> Initializes a new instance of <see cref="UpdateRoomRequest"/>. </summary>
        public UpdateRoomRequest()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpdateRoomRequest"/>. </summary>
        /// <param name="validFrom"> (Optional) The timestamp from when the room is open for joining. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="validUntil"> (Optional) The timestamp from when the room can no longer be joined. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="pstnDialOutEnabled"> Set this flag to true if, at the time of the call, dial out to a PSTN number is enabled in a particular room. By default, this flag is set to false. </param>
        internal UpdateRoomRequest(DateTimeOffset? validFrom, DateTimeOffset? validUntil, bool? pstnDialOutEnabled)
        {
            ValidFrom = validFrom;
            ValidUntil = validUntil;
            PstnDialOutEnabled = pstnDialOutEnabled;
        }

        /// <summary> (Optional) The timestamp from when the room is open for joining. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? ValidFrom { get; set; }
        /// <summary> (Optional) The timestamp from when the room can no longer be joined. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? ValidUntil { get; set; }
        /// <summary> Set this flag to true if, at the time of the call, dial out to a PSTN number is enabled in a particular room. By default, this flag is set to false. </summary>
        public bool? PstnDialOutEnabled { get; set; }
    }
}
