// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.Rooms
{
    public partial class RoomParticipant
    {
        internal static RoomParticipant DeserializeRoomParticipant(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string rawId = default;
            ParticipantRole role = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("rawId"u8))
                {
                    rawId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("role"u8))
                {
                    role = new ParticipantRole(property.Value.GetString());
                    continue;
                }
            }
            return new RoomParticipant(rawId, role);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RoomParticipant FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRoomParticipant(document.RootElement);
        }
    }
}
