// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Rooms
{
    /// <summary> The meeting room. </summary>
    public partial class CommunicationRoom
    {
        /// <summary> Initializes a new instance of <see cref="CommunicationRoom"/>. </summary>
        /// <param name="id"> Unique identifier of a room. This id is server generated. </param>
        /// <param name="createdAt"> The timestamp when the room was created at the server. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="validFrom"> The timestamp from when the room is open for joining. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="validUntil"> The timestamp from when the room can no longer be joined. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="pstnDialOutEnabled"> Set this flag to true if, at the time of the call, dial out to a PSTN number is enabled in a particular room. By default, this flag is set to false. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        internal CommunicationRoom(string id, DateTimeOffset createdAt, DateTimeOffset validFrom, DateTimeOffset validUntil, bool pstnDialOutEnabled)
        {
            Argument.AssertNotNull(id, nameof(id));

            Id = id;
            CreatedAt = createdAt;
            ValidFrom = validFrom;
            ValidUntil = validUntil;
            PstnDialOutEnabled = pstnDialOutEnabled;
        }

        /// <summary> Unique identifier of a room. This id is server generated. </summary>
        public string Id { get; }
        /// <summary> The timestamp when the room was created at the server. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset CreatedAt { get; }
        /// <summary> The timestamp from when the room is open for joining. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset ValidFrom { get; }
        /// <summary> The timestamp from when the room can no longer be joined. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset ValidUntil { get; }
        /// <summary> Set this flag to true if, at the time of the call, dial out to a PSTN number is enabled in a particular room. By default, this flag is set to false. </summary>
        public bool PstnDialOutEnabled { get; }
    }
}
