// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Communication.ProgrammableConnectivity.Samples
{
    public partial class Samples_SimSwap
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SimSwap_Retrieve_SimSwapRetrieve()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                phoneNumber = "+61215310263792",
                networkIdentifier = new
                {
                    identifierType = "IPv6",
                    identifier = "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
                },
            });
            Response response = client.Retrieve("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SimSwap_Retrieve_SimSwapRetrieve_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                phoneNumber = "+61215310263792",
                networkIdentifier = new
                {
                    identifierType = "IPv6",
                    identifier = "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
                },
            });
            Response response = await client.RetrieveAsync("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SimSwap_Retrieve_SimSwapRetrieve_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            SimSwapRetrievalContent body = new SimSwapRetrievalContent(new NetworkIdentifier("IPv6", "2001:0db8:85a3:0000:0000:8a2e:0370:7334"))
            {
                PhoneNumber = "+61215310263792",
            };
            Response<SimSwapRetrievalResult> response = client.Retrieve("zdgrzzaxlodrvewbksn", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SimSwap_Retrieve_SimSwapRetrieve_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            SimSwapRetrievalContent body = new SimSwapRetrievalContent(new NetworkIdentifier("IPv6", "2001:0db8:85a3:0000:0000:8a2e:0370:7334"))
            {
                PhoneNumber = "+61215310263792",
            };
            Response<SimSwapRetrievalResult> response = await client.RetrieveAsync("zdgrzzaxlodrvewbksn", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SimSwap_Verify_SimSwapVerify()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                maxAgeHours = 941,
                networkIdentifier = new
                {
                    identifierType = "ipv4",
                    identifier = "12.12.12.12",
                },
            });
            Response response = client.Verify("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("verificationResult").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SimSwap_Verify_SimSwapVerify_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                maxAgeHours = 941,
                networkIdentifier = new
                {
                    identifierType = "ipv4",
                    identifier = "12.12.12.12",
                },
            });
            Response response = await client.VerifyAsync("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("verificationResult").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SimSwap_Verify_SimSwapVerify_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            SimSwapVerificationContent body = new SimSwapVerificationContent(new NetworkIdentifier("ipv4", "12.12.12.12"))
            {
                MaxAgeHours = 941,
            };
            Response<SimSwapVerificationResult> response = client.Verify("zdgrzzaxlodrvewbksn", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SimSwap_Verify_SimSwapVerify_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            SimSwap client = new ProgrammableConnectivityClient(endpoint, credential).GetSimSwapClient(apiVersion: "2024-02-09-preview");

            SimSwapVerificationContent body = new SimSwapVerificationContent(new NetworkIdentifier("ipv4", "12.12.12.12"))
            {
                MaxAgeHours = 941,
            };
            Response<SimSwapVerificationResult> response = await client.VerifyAsync("zdgrzzaxlodrvewbksn", body);
        }
    }
}
