// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Communication.ProgrammableConnectivity.Samples
{
    public partial class Samples_DeviceNetwork
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeviceNetwork_Retrieve_DeviceNetworkRetrieve()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceNetwork client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceNetworkClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                identifierType = "ipv6",
                identifier = "3001:0da8:75a3:0000:0000:8a2e:0370:7334",
            });
            Response response = client.Retrieve("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("networkCode").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeviceNetwork_Retrieve_DeviceNetworkRetrieve_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceNetwork client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceNetworkClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                identifierType = "ipv6",
                identifier = "3001:0da8:75a3:0000:0000:8a2e:0370:7334",
            });
            Response response = await client.RetrieveAsync("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("networkCode").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeviceNetwork_Retrieve_DeviceNetworkRetrieve_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceNetwork client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceNetworkClient(apiVersion: "2024-02-09-preview");

            NetworkIdentifier body = new NetworkIdentifier("ipv6", "3001:0da8:75a3:0000:0000:8a2e:0370:7334");
            Response<NetworkRetrievalResult> response = client.Retrieve("zdgrzzaxlodrvewbksn", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeviceNetwork_Retrieve_DeviceNetworkRetrieve_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceNetwork client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceNetworkClient(apiVersion: "2024-02-09-preview");

            NetworkIdentifier body = new NetworkIdentifier("ipv6", "3001:0da8:75a3:0000:0000:8a2e:0370:7334");
            Response<NetworkRetrievalResult> response = await client.RetrieveAsync("zdgrzzaxlodrvewbksn", body);
        }
    }
}
