// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Communication.ProgrammableConnectivity.Samples
{
    public partial class Samples_DeviceLocation
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeviceLocation_Verify_DeviceLocationVerify()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceLocation client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceLocationClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                networkIdentifier = new
                {
                    identifierType = "ipv4",
                    identifier = "12.12.12.12",
                },
                latitude = 70,
                longitude = -161,
                accuracy = 91,
                device = new
                {
                    networkAccessIdentifier = "122345@domain.com",
                    phoneNumber = "+447000000000",
                    ipv4Address = new
                    {
                        ipv4 = "12.12.12.12",
                        port = 2442,
                    },
                    ipv6Address = new
                    {
                        ipv6 = "3001:0da8:75a3:0000:0000:8a2e:0370:7334",
                        port = 1643,
                    },
                },
            });
            Response response = client.Verify("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("verificationResult").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeviceLocation_Verify_DeviceLocationVerify_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceLocation client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceLocationClient(apiVersion: "2024-02-09-preview");

            using RequestContent content = RequestContent.Create(new
            {
                networkIdentifier = new
                {
                    identifierType = "ipv4",
                    identifier = "12.12.12.12",
                },
                latitude = 70,
                longitude = -161,
                accuracy = 91,
                device = new
                {
                    networkAccessIdentifier = "122345@domain.com",
                    phoneNumber = "+447000000000",
                    ipv4Address = new
                    {
                        ipv4 = "12.12.12.12",
                        port = 2442,
                    },
                    ipv6Address = new
                    {
                        ipv6 = "3001:0da8:75a3:0000:0000:8a2e:0370:7334",
                        port = 1643,
                    },
                },
            });
            Response response = await client.VerifyAsync("zdgrzzaxlodrvewbksn", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("verificationResult").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeviceLocation_Verify_DeviceLocationVerify_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceLocation client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceLocationClient(apiVersion: "2024-02-09-preview");

            DeviceLocationVerificationContent body = new DeviceLocationVerificationContent(new NetworkIdentifier("ipv4", "12.12.12.12"), 70, -161, 91, new LocationDevice
            {
                NetworkAccessIdentifier = "122345@domain.com",
                PhoneNumber = "+447000000000",
                Ipv4Address = new Ipv4Address("12.12.12.12", 2442),
                Ipv6Address = new Ipv6Address("3001:0da8:75a3:0000:0000:8a2e:0370:7334", 1643),
            });
            Response<DeviceLocationVerificationResult> response = client.Verify("zdgrzzaxlodrvewbksn", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeviceLocation_Verify_DeviceLocationVerify_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceLocation client = new ProgrammableConnectivityClient(endpoint, credential).GetDeviceLocationClient(apiVersion: "2024-02-09-preview");

            DeviceLocationVerificationContent body = new DeviceLocationVerificationContent(new NetworkIdentifier("ipv4", "12.12.12.12"), 70, -161, 91, new LocationDevice
            {
                NetworkAccessIdentifier = "122345@domain.com",
                PhoneNumber = "+447000000000",
                Ipv4Address = new Ipv4Address("12.12.12.12", 2442),
                Ipv6Address = new Ipv6Address("3001:0da8:75a3:0000:0000:8a2e:0370:7334", 1643),
            });
            Response<DeviceLocationVerificationResult> response = await client.VerifyAsync("zdgrzzaxlodrvewbksn", body);
        }
    }
}
