// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Request to retrieve SimSwap date. </summary>
    public partial class SimSwapRetrievalContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SimSwapRetrievalContent"/>. </summary>
        /// <param name="networkIdentifier"> Network to query for this device. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="networkIdentifier"/> is null. </exception>
        public SimSwapRetrievalContent(NetworkIdentifier networkIdentifier)
        {
            Argument.AssertNotNull(networkIdentifier, nameof(networkIdentifier));

            NetworkIdentifier = networkIdentifier;
        }

        /// <summary> Initializes a new instance of <see cref="SimSwapRetrievalContent"/>. </summary>
        /// <param name="phoneNumber"> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </param>
        /// <param name="networkIdentifier"> Network to query for this device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SimSwapRetrievalContent(string phoneNumber, NetworkIdentifier networkIdentifier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PhoneNumber = phoneNumber;
            NetworkIdentifier = networkIdentifier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SimSwapRetrievalContent"/> for deserialization. </summary>
        internal SimSwapRetrievalContent()
        {
        }

        /// <summary> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </summary>
        public string PhoneNumber { get; set; }
        /// <summary> Network to query for this device. </summary>
        public NetworkIdentifier NetworkIdentifier { get; }
    }
}
