// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Client options for ProgrammableConnectivityClient. </summary>
    public partial class ProgrammableConnectivityClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2024_02_09_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2024-02-09-preview". </summary>
            V2024_02_09_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of ProgrammableConnectivityClientOptions. </summary>
        public ProgrammableConnectivityClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2024_02_09_Preview => "2024-02-09-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
