// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Communication.ProgrammableConnectivity
{
    // Data plane generated client.
    /// <summary> Azure Programmable Connectivity (APC) provides a unified interface to the Network APIs of multiple Telecom Operators. Note that Operators may deprecate a Network API with less advance notice than the Azure standard, in which case APC will also deprecate that Network API. </summary>
    public partial class ProgrammableConnectivityClient
    {
        private static readonly string[] AuthorizationScopes = new string[] { "https://management.azure.com//.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of ProgrammableConnectivityClient for mocking. </summary>
        protected ProgrammableConnectivityClient()
        {
        }

        /// <summary> Initializes a new instance of ProgrammableConnectivityClient. </summary>
        /// <param name="endpoint"> An Azure Programmable Connectivity Endpoint providing access to Network APIs, for example https://{region}.apcgatewayapi.azure.com. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public ProgrammableConnectivityClient(Uri endpoint, TokenCredential credential) : this(endpoint, credential, new ProgrammableConnectivityClientOptions())
        {
        }

        /// <summary> Initializes a new instance of ProgrammableConnectivityClient. </summary>
        /// <param name="endpoint"> An Azure Programmable Connectivity Endpoint providing access to Network APIs, for example https://{region}.apcgatewayapi.azure.com. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public ProgrammableConnectivityClient(Uri endpoint, TokenCredential credential, ProgrammableConnectivityClientOptions options)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(credential, nameof(credential));
            options ??= new ProgrammableConnectivityClientOptions();

            ClientDiagnostics = new ClientDiagnostics(options, true);
            _tokenCredential = credential;
            _pipeline = HttpPipelineBuilder.Build(options, Array.Empty<HttpPipelinePolicy>(), new HttpPipelinePolicy[] { new BearerTokenAuthenticationPolicy(_tokenCredential, AuthorizationScopes) }, new ResponseClassifier());
            _endpoint = endpoint;
        }

        /// <summary> Initializes a new instance of DeviceLocation. </summary>
        /// <param name="apiVersion"> The API version to use for this operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apiVersion"/> is null. </exception>
        public virtual DeviceLocation GetDeviceLocationClient(string apiVersion = "2024-02-09-preview")
        {
            Argument.AssertNotNull(apiVersion, nameof(apiVersion));

            return new DeviceLocation(ClientDiagnostics, _pipeline, _tokenCredential, _endpoint, apiVersion);
        }

        /// <summary> Initializes a new instance of DeviceNetwork. </summary>
        /// <param name="apiVersion"> The API version to use for this operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apiVersion"/> is null. </exception>
        public virtual DeviceNetwork GetDeviceNetworkClient(string apiVersion = "2024-02-09-preview")
        {
            Argument.AssertNotNull(apiVersion, nameof(apiVersion));

            return new DeviceNetwork(ClientDiagnostics, _pipeline, _tokenCredential, _endpoint, apiVersion);
        }

        /// <summary> Initializes a new instance of NumberVerification. </summary>
        /// <param name="apiVersion"> The API version to use for this operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apiVersion"/> is null. </exception>
        public virtual NumberVerification GetNumberVerificationClient(string apiVersion = "2024-02-09-preview")
        {
            Argument.AssertNotNull(apiVersion, nameof(apiVersion));

            return new NumberVerification(ClientDiagnostics, _pipeline, _tokenCredential, _endpoint, apiVersion);
        }

        /// <summary> Initializes a new instance of SimSwap. </summary>
        /// <param name="apiVersion"> The API version to use for this operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apiVersion"/> is null. </exception>
        public virtual SimSwap GetSimSwapClient(string apiVersion = "2024-02-09-preview")
        {
            Argument.AssertNotNull(apiVersion, nameof(apiVersion));

            return new SimSwap(ClientDiagnostics, _pipeline, _tokenCredential, _endpoint, apiVersion);
        }
    }
}
