// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Request to verify number of device - first call. </summary>
    public partial class NumberVerificationWithoutCodeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NumberVerificationWithoutCodeContent"/>. </summary>
        /// <param name="networkIdentifier"> Identifier for the network to query for this device. </param>
        /// <param name="redirectUri"> Redirect URI to backend application. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="networkIdentifier"/> or <paramref name="redirectUri"/> is null. </exception>
        public NumberVerificationWithoutCodeContent(NetworkIdentifier networkIdentifier, Uri redirectUri)
        {
            Argument.AssertNotNull(networkIdentifier, nameof(networkIdentifier));
            Argument.AssertNotNull(redirectUri, nameof(redirectUri));

            NetworkIdentifier = networkIdentifier;
            RedirectUri = redirectUri;
        }

        /// <summary> Initializes a new instance of <see cref="NumberVerificationWithoutCodeContent"/>. </summary>
        /// <param name="networkIdentifier"> Identifier for the network to query for this device. </param>
        /// <param name="phoneNumber"> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </param>
        /// <param name="hashedPhoneNumber"> Hashed phone number. SHA-256 (in hexadecimal representation) of the mobile phone number in **E.164 format (starting with country code)**. Optionally prefixed with '+'. </param>
        /// <param name="redirectUri"> Redirect URI to backend application. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NumberVerificationWithoutCodeContent(NetworkIdentifier networkIdentifier, string phoneNumber, string hashedPhoneNumber, Uri redirectUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkIdentifier = networkIdentifier;
            PhoneNumber = phoneNumber;
            HashedPhoneNumber = hashedPhoneNumber;
            RedirectUri = redirectUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NumberVerificationWithoutCodeContent"/> for deserialization. </summary>
        internal NumberVerificationWithoutCodeContent()
        {
        }

        /// <summary> Identifier for the network to query for this device. </summary>
        public NetworkIdentifier NetworkIdentifier { get; }
        /// <summary> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </summary>
        public string PhoneNumber { get; set; }
        /// <summary> Hashed phone number. SHA-256 (in hexadecimal representation) of the mobile phone number in **E.164 format (starting with country code)**. Optionally prefixed with '+'. </summary>
        public string HashedPhoneNumber { get; set; }
        /// <summary> Redirect URI to backend application. </summary>
        public Uri RedirectUri { get; }
    }
}
