// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.ProgrammableConnectivity
{
    public partial class NumberVerificationWithoutCodeContent : IUtf8JsonSerializable, IJsonModel<NumberVerificationWithoutCodeContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NumberVerificationWithoutCodeContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NumberVerificationWithoutCodeContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumberVerificationWithoutCodeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NumberVerificationWithoutCodeContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("networkIdentifier"u8);
            writer.WriteObjectValue(NetworkIdentifier, options);
            if (Optional.IsDefined(PhoneNumber))
            {
                writer.WritePropertyName("phoneNumber"u8);
                writer.WriteStringValue(PhoneNumber);
            }
            if (Optional.IsDefined(HashedPhoneNumber))
            {
                writer.WritePropertyName("hashedPhoneNumber"u8);
                writer.WriteStringValue(HashedPhoneNumber);
            }
            writer.WritePropertyName("redirectUri"u8);
            writer.WriteStringValue(RedirectUri.AbsoluteUri);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NumberVerificationWithoutCodeContent IJsonModel<NumberVerificationWithoutCodeContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumberVerificationWithoutCodeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NumberVerificationWithoutCodeContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNumberVerificationWithoutCodeContent(document.RootElement, options);
        }

        internal static NumberVerificationWithoutCodeContent DeserializeNumberVerificationWithoutCodeContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            NetworkIdentifier networkIdentifier = default;
            string phoneNumber = default;
            string hashedPhoneNumber = default;
            Uri redirectUri = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("networkIdentifier"u8))
                {
                    networkIdentifier = NetworkIdentifier.DeserializeNetworkIdentifier(property.Value, options);
                    continue;
                }
                if (property.NameEquals("phoneNumber"u8))
                {
                    phoneNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hashedPhoneNumber"u8))
                {
                    hashedPhoneNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("redirectUri"u8))
                {
                    redirectUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NumberVerificationWithoutCodeContent(networkIdentifier, phoneNumber, hashedPhoneNumber, redirectUri, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NumberVerificationWithoutCodeContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumberVerificationWithoutCodeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NumberVerificationWithoutCodeContent)} does not support writing '{options.Format}' format.");
            }
        }

        NumberVerificationWithoutCodeContent IPersistableModel<NumberVerificationWithoutCodeContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumberVerificationWithoutCodeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNumberVerificationWithoutCodeContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NumberVerificationWithoutCodeContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NumberVerificationWithoutCodeContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static NumberVerificationWithoutCodeContent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeNumberVerificationWithoutCodeContent(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
