// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Request to verify number of device - second call. </summary>
    public partial class NumberVerificationWithCodeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NumberVerificationWithCodeContent"/>. </summary>
        /// <param name="apcCode"> The code provided by APC in exchange for the operator code. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apcCode"/> is null. </exception>
        public NumberVerificationWithCodeContent(string apcCode)
        {
            Argument.AssertNotNull(apcCode, nameof(apcCode));

            ApcCode = apcCode;
        }

        /// <summary> Initializes a new instance of <see cref="NumberVerificationWithCodeContent"/>. </summary>
        /// <param name="apcCode"> The code provided by APC in exchange for the operator code. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NumberVerificationWithCodeContent(string apcCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApcCode = apcCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NumberVerificationWithCodeContent"/> for deserialization. </summary>
        internal NumberVerificationWithCodeContent()
        {
        }

        /// <summary> The code provided by APC in exchange for the operator code. </summary>
        public string ApcCode { get; }
    }
}
