// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Response verifying number of device. </summary>
    public partial class NumberVerificationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NumberVerificationResult"/>. </summary>
        /// <param name="verificationResult"> True if number if the phone number matches the device, False otherwise. </param>
        internal NumberVerificationResult(bool verificationResult)
        {
            VerificationResult = verificationResult;
        }

        /// <summary> Initializes a new instance of <see cref="NumberVerificationResult"/>. </summary>
        /// <param name="verificationResult"> True if number if the phone number matches the device, False otherwise. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NumberVerificationResult(bool verificationResult, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VerificationResult = verificationResult;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NumberVerificationResult"/> for deserialization. </summary>
        internal NumberVerificationResult()
        {
        }

        /// <summary> True if number if the phone number matches the device, False otherwise. </summary>
        public bool VerificationResult { get; }
    }
}
