// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Device information needed by operator to provide location information. Include exactly one of these properties to identify your device. </summary>
    public partial class LocationDevice
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LocationDevice"/>. </summary>
        public LocationDevice()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LocationDevice"/>. </summary>
        /// <param name="networkAccessIdentifier"> External identifier or network access identifier of the device. </param>
        /// <param name="phoneNumber"> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </param>
        /// <param name="ipv4Address"> The Ipv4 address. </param>
        /// <param name="ipv6Address"> The Ipv6 address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LocationDevice(string networkAccessIdentifier, string phoneNumber, Ipv4Address ipv4Address, Ipv6Address ipv6Address, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkAccessIdentifier = networkAccessIdentifier;
            PhoneNumber = phoneNumber;
            Ipv4Address = ipv4Address;
            Ipv6Address = ipv6Address;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> External identifier or network access identifier of the device. </summary>
        public string NetworkAccessIdentifier { get; set; }
        /// <summary> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </summary>
        public string PhoneNumber { get; set; }
        /// <summary> The Ipv4 address. </summary>
        public Ipv4Address Ipv4Address { get; set; }
        /// <summary> The Ipv6 address. </summary>
        public Ipv6Address Ipv6Address { get; set; }
    }
}
