// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> IPv4 device indicator. </summary>
    public partial class Ipv4Address
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="Ipv4Address"/>. </summary>
        /// <param name="ipv4"> An IPv4 address. This may be specified as an exact address, or as a subnet in CIDR notation. </param>
        /// <param name="port"> User equipment port. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ipv4"/> is null. </exception>
        public Ipv4Address(string ipv4, int port)
        {
            Argument.AssertNotNull(ipv4, nameof(ipv4));

            Ipv4 = ipv4;
            Port = port;
        }

        /// <summary> Initializes a new instance of <see cref="Ipv4Address"/>. </summary>
        /// <param name="ipv4"> An IPv4 address. This may be specified as an exact address, or as a subnet in CIDR notation. </param>
        /// <param name="port"> User equipment port. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal Ipv4Address(string ipv4, int port, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ipv4 = ipv4;
            Port = port;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="Ipv4Address"/> for deserialization. </summary>
        internal Ipv4Address()
        {
        }

        /// <summary> An IPv4 address. This may be specified as an exact address, or as a subnet in CIDR notation. </summary>
        public string Ipv4 { get; }
        /// <summary> User equipment port. </summary>
        public int Port { get; }
    }
}
