// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Request to verify Location. </summary>
    public partial class DeviceLocationVerificationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceLocationVerificationContent"/>. </summary>
        /// <param name="networkIdentifier"> Network to query for this device, or device information to enable network routing. </param>
        /// <param name="latitude"> Latitude of location to be verified. </param>
        /// <param name="longitude"> Longitude of location to be verified. </param>
        /// <param name="accuracy"> Accuracy expected for location verification in kilometers. </param>
        /// <param name="device"> The device to find the location for. Exactly one of Network Access Code, Phone Number, IPv4 address, or IPv6 address. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="networkIdentifier"/> or <paramref name="device"/> is null. </exception>
        public DeviceLocationVerificationContent(NetworkIdentifier networkIdentifier, double latitude, double longitude, int accuracy, LocationDevice device)
        {
            Argument.AssertNotNull(networkIdentifier, nameof(networkIdentifier));
            Argument.AssertNotNull(device, nameof(device));

            NetworkIdentifier = networkIdentifier;
            Latitude = latitude;
            Longitude = longitude;
            Accuracy = accuracy;
            Device = device;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceLocationVerificationContent"/>. </summary>
        /// <param name="networkIdentifier"> Network to query for this device, or device information to enable network routing. </param>
        /// <param name="latitude"> Latitude of location to be verified. </param>
        /// <param name="longitude"> Longitude of location to be verified. </param>
        /// <param name="accuracy"> Accuracy expected for location verification in kilometers. </param>
        /// <param name="device"> The device to find the location for. Exactly one of Network Access Code, Phone Number, IPv4 address, or IPv6 address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceLocationVerificationContent(NetworkIdentifier networkIdentifier, double latitude, double longitude, int accuracy, LocationDevice device, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkIdentifier = networkIdentifier;
            Latitude = latitude;
            Longitude = longitude;
            Accuracy = accuracy;
            Device = device;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceLocationVerificationContent"/> for deserialization. </summary>
        internal DeviceLocationVerificationContent()
        {
        }

        /// <summary> Network to query for this device, or device information to enable network routing. </summary>
        public NetworkIdentifier NetworkIdentifier { get; }
        /// <summary> Latitude of location to be verified. </summary>
        public double Latitude { get; }
        /// <summary> Longitude of location to be verified. </summary>
        public double Longitude { get; }
        /// <summary> Accuracy expected for location verification in kilometers. </summary>
        public int Accuracy { get; }
        /// <summary> The device to find the location for. Exactly one of Network Access Code, Phone Number, IPv4 address, or IPv6 address. </summary>
        public LocationDevice Device { get; }
    }
}
