// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.ProgrammableConnectivity
{
    public partial class DeviceLocationVerificationContent : IUtf8JsonSerializable, IJsonModel<DeviceLocationVerificationContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DeviceLocationVerificationContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DeviceLocationVerificationContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceLocationVerificationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeviceLocationVerificationContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("networkIdentifier"u8);
            writer.WriteObjectValue(NetworkIdentifier, options);
            writer.WritePropertyName("latitude"u8);
            writer.WriteNumberValue(Latitude);
            writer.WritePropertyName("longitude"u8);
            writer.WriteNumberValue(Longitude);
            writer.WritePropertyName("accuracy"u8);
            writer.WriteNumberValue(Accuracy);
            writer.WritePropertyName("device"u8);
            writer.WriteObjectValue(Device, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DeviceLocationVerificationContent IJsonModel<DeviceLocationVerificationContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceLocationVerificationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DeviceLocationVerificationContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDeviceLocationVerificationContent(document.RootElement, options);
        }

        internal static DeviceLocationVerificationContent DeserializeDeviceLocationVerificationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            NetworkIdentifier networkIdentifier = default;
            double latitude = default;
            double longitude = default;
            int accuracy = default;
            LocationDevice device = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("networkIdentifier"u8))
                {
                    networkIdentifier = NetworkIdentifier.DeserializeNetworkIdentifier(property.Value, options);
                    continue;
                }
                if (property.NameEquals("latitude"u8))
                {
                    latitude = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("longitude"u8))
                {
                    longitude = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("accuracy"u8))
                {
                    accuracy = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("device"u8))
                {
                    device = LocationDevice.DeserializeLocationDevice(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DeviceLocationVerificationContent(
                networkIdentifier,
                latitude,
                longitude,
                accuracy,
                device,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DeviceLocationVerificationContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceLocationVerificationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DeviceLocationVerificationContent)} does not support writing '{options.Format}' format.");
            }
        }

        DeviceLocationVerificationContent IPersistableModel<DeviceLocationVerificationContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DeviceLocationVerificationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDeviceLocationVerificationContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DeviceLocationVerificationContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DeviceLocationVerificationContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DeviceLocationVerificationContent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDeviceLocationVerificationContent(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
