// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.ProgrammableConnectivity
{
    /// <summary> Model factory for models. </summary>
    public static partial class CommunicationProgrammableConnectivityModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.SimSwapRetrievalContent"/>. </summary>
        /// <param name="phoneNumber"> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </param>
        /// <param name="networkIdentifier"> Network to query for this device. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.SimSwapRetrievalContent"/> instance for mocking. </returns>
        public static SimSwapRetrievalContent SimSwapRetrievalContent(string phoneNumber = null, NetworkIdentifier networkIdentifier = null)
        {
            return new SimSwapRetrievalContent(phoneNumber, networkIdentifier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.SimSwapRetrievalResult"/>. </summary>
        /// <param name="date"> Datetime of most recent swap for SIM. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.SimSwapRetrievalResult"/> instance for mocking. </returns>
        public static SimSwapRetrievalResult SimSwapRetrievalResult(DateTimeOffset? date = null)
        {
            return new SimSwapRetrievalResult(date, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.SimSwapVerificationContent"/>. </summary>
        /// <param name="phoneNumber"> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </param>
        /// <param name="maxAgeHours"> Maximum lookback for SimSwap verification. </param>
        /// <param name="networkIdentifier"> Identifier for the network to query for this device. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.SimSwapVerificationContent"/> instance for mocking. </returns>
        public static SimSwapVerificationContent SimSwapVerificationContent(string phoneNumber = null, int? maxAgeHours = null, NetworkIdentifier networkIdentifier = null)
        {
            return new SimSwapVerificationContent(phoneNumber, maxAgeHours, networkIdentifier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.SimSwapVerificationResult"/>. </summary>
        /// <param name="verificationResult"> True if the SIM has swapped in the specified period, False otherwise. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.SimSwapVerificationResult"/> instance for mocking. </returns>
        public static SimSwapVerificationResult SimSwapVerificationResult(bool verificationResult = default)
        {
            return new SimSwapVerificationResult(verificationResult, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.NumberVerificationWithoutCodeContent"/>. </summary>
        /// <param name="networkIdentifier"> Identifier for the network to query for this device. </param>
        /// <param name="phoneNumber"> Phone number in E.164 format (starting with country code), and optionally prefixed with '+'. </param>
        /// <param name="hashedPhoneNumber"> Hashed phone number. SHA-256 (in hexadecimal representation) of the mobile phone number in **E.164 format (starting with country code)**. Optionally prefixed with '+'. </param>
        /// <param name="redirectUri"> Redirect URI to backend application. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.NumberVerificationWithoutCodeContent"/> instance for mocking. </returns>
        public static NumberVerificationWithoutCodeContent NumberVerificationWithoutCodeContent(NetworkIdentifier networkIdentifier = null, string phoneNumber = null, string hashedPhoneNumber = null, Uri redirectUri = null)
        {
            return new NumberVerificationWithoutCodeContent(networkIdentifier, phoneNumber, hashedPhoneNumber, redirectUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.NumberVerificationResult"/>. </summary>
        /// <param name="verificationResult"> True if number if the phone number matches the device, False otherwise. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.NumberVerificationResult"/> instance for mocking. </returns>
        public static NumberVerificationResult NumberVerificationResult(bool verificationResult = default)
        {
            return new NumberVerificationResult(verificationResult, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.NetworkRetrievalResult"/>. </summary>
        /// <param name="networkCode"> The identifier for the network. This can be used as the networkIdentifier for the service APIs. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.NetworkRetrievalResult"/> instance for mocking. </returns>
        public static NetworkRetrievalResult NetworkRetrievalResult(string networkCode = null)
        {
            return new NetworkRetrievalResult(networkCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProgrammableConnectivity.DeviceLocationVerificationResult"/>. </summary>
        /// <param name="verificationResult"> True if the location is in the specified area, False otherwise. </param>
        /// <returns> A new <see cref="ProgrammableConnectivity.DeviceLocationVerificationResult"/> instance for mocking. </returns>
        public static DeviceLocationVerificationResult DeviceLocationVerificationResult(bool verificationResult = default)
        {
            return new DeviceLocationVerificationResult(verificationResult, serializedAdditionalRawData: null);
        }
    }
}
