// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.PhoneNumbers.SipRouting
{
    /// <summary> Model factory for read-only models. </summary>
    internal static partial class SipRoutingModelFactory
    {
        /// <summary> Initializes a new instance of SipTrunkRoute. </summary>
        /// <param name="description"> Gets or sets description of the route. </param>
        /// <param name="name"> Gets or sets name of the route. </param>
        /// <param name="numberPattern">
        /// Gets or sets regex number pattern for routing calls. .NET regex format is supported.
        /// The regex should match only digits with an optional &apos;+&apos; prefix without spaces.
        /// I.e. &quot;^\+[1-9][0-9]{3,23}$&quot;.
        /// </param>
        /// <param name="trunks"> Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN. </param>
        /// <returns> A new <see cref="SipRouting.SipTrunkRoute"/> instance for mocking. </returns>
        public static SipTrunkRoute SipTrunkRoute(string description = null, string name = null, string numberPattern = null, IEnumerable<string> trunks = null)
        {
            trunks ??= new List<string>();

            return new SipTrunkRoute(description, name, numberPattern, trunks?.ToList());
        }
    }
}
