// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.Communication.PhoneNumbers.SipRouting
{
    /// <summary> Represents a trunk route for routing calls. </summary>
    public partial class SipTrunkRoute
    {

        /// <summary> Initializes a new instance of SipTrunkRoute. </summary>
        /// <param name="description"> Gets or sets description of the route. </param>
        /// <param name="name"> Gets or sets name of the route. </param>
        /// <param name="numberPattern">
        /// Gets or sets regex number pattern for routing calls. .NET regex format is supported.
        /// The regex should match only digits with an optional &apos;+&apos; prefix without spaces.
        /// I.e. &quot;^\+[1-9][0-9]{3,23}$&quot;.
        /// </param>
        /// <param name="trunks"> Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN. </param>
        internal SipTrunkRoute(string description, string name, string numberPattern, IReadOnlyList<string> trunks)
        {
            Description = description;
            Name = name;
            NumberPattern = numberPattern;
            Trunks = trunks;
        }
    }
}
