// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> The result of a phone number search operation. </summary>
    public partial class PhoneNumberSearchResult
    {
        /// <summary> Initializes a new instance of <see cref="PhoneNumberSearchResult"/>. </summary>
        /// <param name="searchId"> The search id. </param>
        /// <param name="phoneNumbers"> The phone numbers that are available. Can be fewer than the desired search quantity. </param>
        /// <param name="phoneNumberType"> The phone number's type, e.g. geographic, or tollFree. </param>
        /// <param name="assignmentType"> Phone number's assignment type. </param>
        /// <param name="capabilities"> Capabilities of a phone number. </param>
        /// <param name="cost"> The incurred cost for a single phone number. </param>
        /// <param name="searchExpiresOn"> The date that this search result expires and phone numbers are no longer on hold. A search result expires in less than 15min, e.g. 2020-11-19T16:31:49.048Z. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="searchId"/>, <paramref name="phoneNumbers"/>, <paramref name="capabilities"/> or <paramref name="cost"/> is null. </exception>
        internal PhoneNumberSearchResult(string searchId, IEnumerable<string> phoneNumbers, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities, PhoneNumberCost cost, DateTimeOffset searchExpiresOn)
        {
            Argument.AssertNotNull(searchId, nameof(searchId));
            Argument.AssertNotNull(phoneNumbers, nameof(phoneNumbers));
            Argument.AssertNotNull(capabilities, nameof(capabilities));
            Argument.AssertNotNull(cost, nameof(cost));

            SearchId = searchId;
            PhoneNumbers = phoneNumbers.ToList();
            PhoneNumberType = phoneNumberType;
            AssignmentType = assignmentType;
            Capabilities = capabilities;
            Cost = cost;
            SearchExpiresOn = searchExpiresOn;
        }

        /// <summary> Initializes a new instance of <see cref="PhoneNumberSearchResult"/>. </summary>
        /// <param name="searchId"> The search id. </param>
        /// <param name="phoneNumbers"> The phone numbers that are available. Can be fewer than the desired search quantity. </param>
        /// <param name="phoneNumberType"> The phone number's type, e.g. geographic, or tollFree. </param>
        /// <param name="assignmentType"> Phone number's assignment type. </param>
        /// <param name="capabilities"> Capabilities of a phone number. </param>
        /// <param name="cost"> The incurred cost for a single phone number. </param>
        /// <param name="searchExpiresOn"> The date that this search result expires and phone numbers are no longer on hold. A search result expires in less than 15min, e.g. 2020-11-19T16:31:49.048Z. </param>
        /// <param name="errorCode"> The error code of the search. </param>
        /// <param name="error"> Mapping Error Messages to Codes. </param>
        internal PhoneNumberSearchResult(string searchId, IReadOnlyList<string> phoneNumbers, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities, PhoneNumberCost cost, DateTimeOffset searchExpiresOn, int? errorCode, PhoneNumberSearchResultError? error)
        {
            SearchId = searchId;
            PhoneNumbers = phoneNumbers;
            PhoneNumberType = phoneNumberType;
            AssignmentType = assignmentType;
            Capabilities = capabilities;
            Cost = cost;
            SearchExpiresOn = searchExpiresOn;
            ErrorCode = errorCode;
            Error = error;
        }

        /// <summary> The search id. </summary>
        public string SearchId { get; }
        /// <summary> The phone numbers that are available. Can be fewer than the desired search quantity. </summary>
        public IReadOnlyList<string> PhoneNumbers { get; }
        /// <summary> The phone number's type, e.g. geographic, or tollFree. </summary>
        public PhoneNumberType PhoneNumberType { get; }
        /// <summary> Phone number's assignment type. </summary>
        public PhoneNumberAssignmentType AssignmentType { get; }
        /// <summary> Capabilities of a phone number. </summary>
        public PhoneNumberCapabilities Capabilities { get; }
        /// <summary> The incurred cost for a single phone number. </summary>
        public PhoneNumberCost Cost { get; }
        /// <summary> The error code of the search. </summary>
        public int? ErrorCode { get; }
        /// <summary> Mapping Error Messages to Codes. </summary>
        public PhoneNumberSearchResultError? Error { get; }
    }
}
