// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Communication.PhoneNumbers
{
    public partial class PhoneNumberSearchResult
    {
        internal static PhoneNumberSearchResult DeserializePhoneNumberSearchResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string searchId = default;
            IReadOnlyList<string> phoneNumbers = default;
            PhoneNumberType phoneNumberType = default;
            PhoneNumberAssignmentType assignmentType = default;
            PhoneNumberCapabilities capabilities = default;
            PhoneNumberCost cost = default;
            DateTimeOffset searchExpiresBy = default;
            int? errorCode = default;
            PhoneNumberSearchResultError? error = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("searchId"u8))
                {
                    searchId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("phoneNumbers"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    phoneNumbers = array;
                    continue;
                }
                if (property.NameEquals("phoneNumberType"u8))
                {
                    phoneNumberType = new PhoneNumberType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("assignmentType"u8))
                {
                    assignmentType = new PhoneNumberAssignmentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("capabilities"u8))
                {
                    capabilities = PhoneNumberCapabilities.DeserializePhoneNumberCapabilities(property.Value);
                    continue;
                }
                if (property.NameEquals("cost"u8))
                {
                    cost = PhoneNumberCost.DeserializePhoneNumberCost(property.Value);
                    continue;
                }
                if (property.NameEquals("searchExpiresBy"u8))
                {
                    searchExpiresBy = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("errorCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    errorCode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = new PhoneNumberSearchResultError(property.Value.GetString());
                    continue;
                }
            }
            return new PhoneNumberSearchResult(
                searchId,
                phoneNumbers,
                phoneNumberType,
                assignmentType,
                capabilities,
                cost,
                searchExpiresBy,
                errorCode,
                error);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PhoneNumberSearchResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePhoneNumberSearchResult(document.RootElement);
        }
    }
}
