// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.PhoneNumbers
{
    internal partial class PhoneNumberSearchRequest : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("phoneNumberType"u8);
            writer.WriteStringValue(PhoneNumberType.ToString());
            writer.WritePropertyName("assignmentType"u8);
            writer.WriteStringValue(AssignmentType.ToString());
            writer.WritePropertyName("capabilities"u8);
            writer.WriteObjectValue(Capabilities);
            if (Optional.IsDefined(AreaCode))
            {
                writer.WritePropertyName("areaCode"u8);
                writer.WriteStringValue(AreaCode);
            }
            if (Optional.IsDefined(Quantity))
            {
                writer.WritePropertyName("quantity"u8);
                writer.WriteNumberValue(Quantity.Value);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
