// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> The type of operation, e.g. Search. </summary>
    internal readonly partial struct PhoneNumberOperationType : IEquatable<PhoneNumberOperationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PhoneNumberOperationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PhoneNumberOperationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PurchaseValue = "purchase";
        private const string ReleasePhoneNumberValue = "releasePhoneNumber";
        private const string SearchValue = "search";
        private const string UpdatePhoneNumberCapabilitiesValue = "updatePhoneNumberCapabilities";

        /// <summary> purchase. </summary>
        public static PhoneNumberOperationType Purchase { get; } = new PhoneNumberOperationType(PurchaseValue);
        /// <summary> releasePhoneNumber. </summary>
        public static PhoneNumberOperationType ReleasePhoneNumber { get; } = new PhoneNumberOperationType(ReleasePhoneNumberValue);
        /// <summary> search. </summary>
        public static PhoneNumberOperationType Search { get; } = new PhoneNumberOperationType(SearchValue);
        /// <summary> updatePhoneNumberCapabilities. </summary>
        public static PhoneNumberOperationType UpdatePhoneNumberCapabilities { get; } = new PhoneNumberOperationType(UpdatePhoneNumberCapabilitiesValue);
        /// <summary> Determines if two <see cref="PhoneNumberOperationType"/> values are the same. </summary>
        public static bool operator ==(PhoneNumberOperationType left, PhoneNumberOperationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PhoneNumberOperationType"/> values are not the same. </summary>
        public static bool operator !=(PhoneNumberOperationType left, PhoneNumberOperationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PhoneNumberOperationType"/>. </summary>
        public static implicit operator PhoneNumberOperationType(string value) => new PhoneNumberOperationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PhoneNumberOperationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PhoneNumberOperationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
