// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> Represents a locality. </summary>
    public partial class PhoneNumberLocality
    {
        /// <summary> Initializes a new instance of <see cref="PhoneNumberLocality"/>. </summary>
        /// <param name="localizedName"> Represents the localized name of the locality. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="localizedName"/> is null. </exception>
        internal PhoneNumberLocality(string localizedName)
        {
            Argument.AssertNotNull(localizedName, nameof(localizedName));

            LocalizedName = localizedName;
        }

        /// <summary> Initializes a new instance of <see cref="PhoneNumberLocality"/>. </summary>
        /// <param name="localizedName"> Represents the localized name of the locality. </param>
        /// <param name="administrativeDivision"> Represents an administrative division. e.g. state or province. </param>
        internal PhoneNumberLocality(string localizedName, PhoneNumberAdministrativeDivision administrativeDivision)
        {
            LocalizedName = localizedName;
            AdministrativeDivision = administrativeDivision;
        }

        /// <summary> Represents the localized name of the locality. </summary>
        public string LocalizedName { get; }
        /// <summary> Represents an administrative division. e.g. state or province. </summary>
        public PhoneNumberAdministrativeDivision AdministrativeDivision { get; }
    }
}
