// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.PhoneNumbers
{
    public partial class PhoneNumberLocality
    {
        internal static PhoneNumberLocality DeserializePhoneNumberLocality(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string localizedName = default;
            PhoneNumberAdministrativeDivision administrativeDivision = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("localizedName"u8))
                {
                    localizedName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("administrativeDivision"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    administrativeDivision = PhoneNumberAdministrativeDivision.DeserializePhoneNumberAdministrativeDivision(property.Value);
                    continue;
                }
            }
            return new PhoneNumberLocality(localizedName, administrativeDivision);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PhoneNumberLocality FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePhoneNumberLocality(document.RootElement);
        }
    }
}
