// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.PhoneNumbers
{
    public partial class PhoneNumberCost
    {
        internal static PhoneNumberCost DeserializePhoneNumberCost(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double amount = default;
            string currencyCode = default;
            BillingFrequency billingFrequency = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("amount"u8))
                {
                    amount = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("currencyCode"u8))
                {
                    currencyCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("billingFrequency"u8))
                {
                    billingFrequency = new BillingFrequency(property.Value.GetString());
                    continue;
                }
            }
            return new PhoneNumberCost(amount, currencyCode, billingFrequency);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PhoneNumberCost FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePhoneNumberCost(document.RootElement);
        }
    }
}
