// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.PhoneNumbers
{
    public partial class PhoneNumberCapabilities : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("calling"u8);
            writer.WriteStringValue(Calling.ToString());
            writer.WritePropertyName("sms"u8);
            writer.WriteStringValue(Sms.ToString());
            writer.WriteEndObject();
        }

        internal static PhoneNumberCapabilities DeserializePhoneNumberCapabilities(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PhoneNumberCapabilityType calling = default;
            PhoneNumberCapabilityType sms = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("calling"u8))
                {
                    calling = new PhoneNumberCapabilityType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sms"u8))
                {
                    sms = new PhoneNumberCapabilityType(property.Value.GetString());
                    continue;
                }
            }
            return new PhoneNumberCapabilities(calling, sms);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PhoneNumberCapabilities FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePhoneNumberCapabilities(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
