// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> Represents a search result containing format and operator information associated with the requested phone numbers. </summary>
    public partial class OperatorInformationResult
    {
        /// <summary> Initializes a new instance of <see cref="OperatorInformationResult"/>. </summary>
        internal OperatorInformationResult()
        {
            Values = new ChangeTrackingList<OperatorInformation>();
        }

        /// <summary> Initializes a new instance of <see cref="OperatorInformationResult"/>. </summary>
        /// <param name="values">
        /// Results of a search.
        /// This array will have one entry per requested phone number which will contain the relevant operator information.
        /// </param>
        internal OperatorInformationResult(IReadOnlyList<OperatorInformation> values)
        {
            Values = values;
        }

        /// <summary>
        /// Results of a search.
        /// This array will have one entry per requested phone number which will contain the relevant operator information.
        /// </summary>
        public IReadOnlyList<OperatorInformation> Values { get; }
    }
}
