// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> Represents a search request for operator information for the given phone numbers. </summary>
    internal partial class OperatorInformationRequest
    {
        /// <summary> Initializes a new instance of <see cref="OperatorInformationRequest"/>. </summary>
        /// <param name="phoneNumbers"> Phone number(s) whose operator information is being requested. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="phoneNumbers"/> is null. </exception>
        public OperatorInformationRequest(IEnumerable<string> phoneNumbers)
        {
            Argument.AssertNotNull(phoneNumbers, nameof(phoneNumbers));

            PhoneNumbers = phoneNumbers.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="OperatorInformationRequest"/>. </summary>
        /// <param name="phoneNumbers"> Phone number(s) whose operator information is being requested. </param>
        /// <param name="options"> Represents options to modify a search request for operator information. </param>
        internal OperatorInformationRequest(IList<string> phoneNumbers, OperatorInformationOptions options)
        {
            PhoneNumbers = phoneNumbers;
            Options = options;
        }

        /// <summary> Phone number(s) whose operator information is being requested. </summary>
        public IList<string> PhoneNumbers { get; }
        /// <summary> Represents options to modify a search request for operator information. </summary>
        public OperatorInformationOptions Options { get; set; }
    }
}
