// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> Represents metadata about a phone number that is controlled/provided by that phone number's operator. </summary>
    public partial class OperatorInformation
    {
        /// <summary> Initializes a new instance of <see cref="OperatorInformation"/>. </summary>
        /// <param name="phoneNumber"> E.164 formatted string representation of the phone number. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="phoneNumber"/> is null. </exception>
        internal OperatorInformation(string phoneNumber)
        {
            Argument.AssertNotNull(phoneNumber, nameof(phoneNumber));

            PhoneNumber = phoneNumber;
        }

        /// <summary> Initializes a new instance of <see cref="OperatorInformation"/>. </summary>
        /// <param name="phoneNumber"> E.164 formatted string representation of the phone number. </param>
        /// <param name="nationalFormat"> National format of the phone number. </param>
        /// <param name="internationalFormat"> International format of the phone number. </param>
        /// <param name="isoCountryCode"> ISO 3166-1 two character ('alpha-2') code associated with the phone number. </param>
        /// <param name="numberType"> Type of service associated with the phone number. </param>
        /// <param name="operatorDetails"> Represents metadata describing the operator of a phone number. </param>
        internal OperatorInformation(string phoneNumber, string nationalFormat, string internationalFormat, string isoCountryCode, OperatorNumberType? numberType, OperatorDetails operatorDetails)
        {
            PhoneNumber = phoneNumber;
            NationalFormat = nationalFormat;
            InternationalFormat = internationalFormat;
            IsoCountryCode = isoCountryCode;
            NumberType = numberType;
            OperatorDetails = operatorDetails;
        }

        /// <summary> E.164 formatted string representation of the phone number. </summary>
        public string PhoneNumber { get; }
        /// <summary> National format of the phone number. </summary>
        public string NationalFormat { get; }
        /// <summary> International format of the phone number. </summary>
        public string InternationalFormat { get; }
        /// <summary> ISO 3166-1 two character ('alpha-2') code associated with the phone number. </summary>
        public string IsoCountryCode { get; }
        /// <summary> Type of service associated with the phone number. </summary>
        public OperatorNumberType? NumberType { get; }
        /// <summary> Represents metadata describing the operator of a phone number. </summary>
        public OperatorDetails OperatorDetails { get; }
    }
}
