// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.PhoneNumbers
{
    public partial class OperatorInformation
    {
        internal static OperatorInformation DeserializeOperatorInformation(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string phoneNumber = default;
            string nationalFormat = default;
            string internationalFormat = default;
            string isoCountryCode = default;
            OperatorNumberType? numberType = default;
            OperatorDetails operatorDetails = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("phoneNumber"u8))
                {
                    phoneNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nationalFormat"u8))
                {
                    nationalFormat = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("internationalFormat"u8))
                {
                    internationalFormat = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isoCountryCode"u8))
                {
                    isoCountryCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("numberType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numberType = new OperatorNumberType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("operatorDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    operatorDetails = OperatorDetails.DeserializeOperatorDetails(property.Value);
                    continue;
                }
            }
            return new OperatorInformation(
                phoneNumber,
                nationalFormat,
                internationalFormat,
                isoCountryCode,
                numberType,
                operatorDetails);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static OperatorInformation FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeOperatorInformation(document.RootElement);
        }
    }
}
