// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> Represents metadata describing the operator of a phone number. </summary>
    public partial class OperatorDetails
    {
        /// <summary> Initializes a new instance of <see cref="OperatorDetails"/>. </summary>
        /// <param name="name"> Name of the phone operator. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        internal OperatorDetails(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="OperatorDetails"/>. </summary>
        /// <param name="name"> Name of the phone operator. </param>
        /// <param name="mobileNetworkCode"> Mobile Network Code. </param>
        /// <param name="mobileCountryCode"> Mobile Country Code. </param>
        internal OperatorDetails(string name, string mobileNetworkCode, string mobileCountryCode)
        {
            Name = name;
            MobileNetworkCode = mobileNetworkCode;
            MobileCountryCode = mobileCountryCode;
        }

        /// <summary> Name of the phone operator. </summary>
        public string Name { get; }
        /// <summary> Mobile Network Code. </summary>
        public string MobileNetworkCode { get; }
        /// <summary> Mobile Country Code. </summary>
        public string MobileCountryCode { get; }
    }
}
