// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.PhoneNumbers
{
    public partial class OperatorDetails
    {
        internal static OperatorDetails DeserializeOperatorDetails(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string mobileNetworkCode = default;
            string mobileCountryCode = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mobileNetworkCode"u8))
                {
                    mobileNetworkCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("mobileCountryCode"u8))
                {
                    mobileCountryCode = property.Value.GetString();
                    continue;
                }
            }
            return new OperatorDetails(name, mobileNetworkCode, mobileCountryCode);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static OperatorDetails FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeOperatorDetails(document.RootElement);
        }
    }
}
