// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.PhoneNumbers
{
    /// <summary> The frequency with which the cost gets billed. </summary>
    public readonly partial struct BillingFrequency : IEquatable<BillingFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MonthlyValue = "monthly";

        /// <summary> monthly. </summary>
        public static BillingFrequency Monthly { get; } = new BillingFrequency(MonthlyValue);
        /// <summary> Determines if two <see cref="BillingFrequency"/> values are the same. </summary>
        public static bool operator ==(BillingFrequency left, BillingFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingFrequency"/> values are not the same. </summary>
        public static bool operator !=(BillingFrequency left, BillingFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingFrequency"/>. </summary>
        public static implicit operator BillingFrequency(string value) => new BillingFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
