---
page_type: sample
languages:
- csharp
products:
- azure
- azure-communication-services
name: Azure Communication Phone Number samples for .NET
description: Samples for the Azure.Communication.PhoneNumbers client library
---

# Azure Communication Phone Number SDK samples

Azure Communication Phone Number is a client library that is used to do operations necessary for using different services offered by Azure Communication Services, such as calling, chat, SMS, PSTN etc.
To get started you will need to have an Azure Subscription. Once you have this you can go into the Azure portal and create Azure Communication Services resource. The page will give you necessary information to be able to use the sample codes here such as connections string, shared access key, etc.

This client library allows to do following operations:
 - Purchase, configure and release phone numbers.
 - Manage SIP routing configuration.

 #### You can find samples for each of these functions below.
 - Manage phone numbers [synchronously][sample_phonenumbers] or [asynchronously][sample_phonenumbers_async]
 - Manage SIP routing configuration [synchronously][sample_siprouting] or [asynchronously][sample_siprouting_async]

<!-- LINKS -->
[sample_phonenumbers]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/communication/Azure.Communication.PhoneNumbers/samples/Sample_PhoneNumbersClient.md
[sample_phonenumbers_async]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/communication/Azure.Communication.PhoneNumbers/samples/Sample_PhoneNumbersClientAsync.md
[sample_siprouting]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/communication/Azure.Communication.PhoneNumbers/samples/Sample_SipRoutingClient.md
[sample_siprouting_async]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/communication/Azure.Communication.PhoneNumbers/samples/Sample_SipRoutingClientAsync.md
