// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.Messages
{
    public partial class NotificationContent : IUtf8JsonSerializable, IJsonModel<NotificationContent>
    {
        internal static NotificationContent DeserializeNotificationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "audio": return AudioNotificationContent.DeserializeAudioNotificationContent(element, options);
                    case "document": return DocumentNotificationContent.DeserializeDocumentNotificationContent(element, options);
                    case "image": return ImageNotificationContent.DeserializeImageNotificationContent(element, options);
#pragma warning disable CS0618 // Type or member is obsolete - Need to manually add this custom code due to the defect here: https://github.com/Azure/autorest.csharp/issues/5114
                    case "image_v0": return MediaNotificationContent.DeserializeMediaNotificationContent(element, options);
#pragma warning restore CS0618 // Type or member is obsolete - Need to manually add this custom code due to the defect here: https://github.com/Azure/autorest.csharp/issues/5114
                    case "template": return TemplateNotificationContent.DeserializeTemplateNotificationContent(element, options);
                    case "text": return TextNotificationContent.DeserializeTextNotificationContent(element, options);
                    case "video": return VideoNotificationContent.DeserializeVideoNotificationContent(element, options);
                }
            }
            return UnknownNotificationContent.DeserializeUnknownNotificationContent(element, options);
        }
    }
}
