// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.Messages.Models.Channels
{
    /// <summary> The template bindings for WhatsApp. </summary>
    public partial class WhatsAppMessageTemplateBindings : MessageTemplateBindings
    {
        /// <summary> Initializes a new instance of <see cref="WhatsAppMessageTemplateBindings"/>. </summary>
        public WhatsAppMessageTemplateBindings()
        {
            Kind = MessageTemplateBindingsKind.WhatsApp;
            Header = new ChangeTrackingList<WhatsAppMessageTemplateBindingsComponent>();
            Body = new ChangeTrackingList<WhatsAppMessageTemplateBindingsComponent>();
            Footer = new ChangeTrackingList<WhatsAppMessageTemplateBindingsComponent>();
            Buttons = new ChangeTrackingList<WhatsAppMessageTemplateBindingsButton>();
        }

        /// <summary> Initializes a new instance of <see cref="WhatsAppMessageTemplateBindings"/>. </summary>
        /// <param name="kind"> The type discriminator describing a template bindings type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="header"> The header template bindings. </param>
        /// <param name="body"> The body template bindings. </param>
        /// <param name="footer"> The footer template bindings. </param>
        /// <param name="buttons"> The button template bindings. </param>
        internal WhatsAppMessageTemplateBindings(MessageTemplateBindingsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<WhatsAppMessageTemplateBindingsComponent> header, IList<WhatsAppMessageTemplateBindingsComponent> body, IList<WhatsAppMessageTemplateBindingsComponent> footer, IList<WhatsAppMessageTemplateBindingsButton> buttons) : base(kind, serializedAdditionalRawData)
        {
            Header = header;
            Body = body;
            Footer = footer;
            Buttons = buttons;
        }

        /// <summary> The header template bindings. </summary>
        public IList<WhatsAppMessageTemplateBindingsComponent> Header { get; }
        /// <summary> The body template bindings. </summary>
        public IList<WhatsAppMessageTemplateBindingsComponent> Body { get; }
        /// <summary> The footer template bindings. </summary>
        public IList<WhatsAppMessageTemplateBindingsComponent> Footer { get; }
        /// <summary> The button template bindings. </summary>
        public IList<WhatsAppMessageTemplateBindingsButton> Buttons { get; }
    }
}
