// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Messages.Models.Channels
{
    /// <summary> The WhatsApp button sub type. </summary>
    public readonly partial struct WhatsAppMessageButtonSubType : IEquatable<WhatsAppMessageButtonSubType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WhatsAppMessageButtonSubType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WhatsAppMessageButtonSubType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QuickReplyValue = "quickReply";
        private const string UrlValue = "url";

        /// <summary> The WhatsApp button sub type is quick reply. </summary>
        public static WhatsAppMessageButtonSubType QuickReply { get; } = new WhatsAppMessageButtonSubType(QuickReplyValue);
        /// <summary> The WhatsApp button sub type is url. </summary>
        public static WhatsAppMessageButtonSubType Url { get; } = new WhatsAppMessageButtonSubType(UrlValue);
        /// <summary> Determines if two <see cref="WhatsAppMessageButtonSubType"/> values are the same. </summary>
        public static bool operator ==(WhatsAppMessageButtonSubType left, WhatsAppMessageButtonSubType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WhatsAppMessageButtonSubType"/> values are not the same. </summary>
        public static bool operator !=(WhatsAppMessageButtonSubType left, WhatsAppMessageButtonSubType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WhatsAppMessageButtonSubType"/>. </summary>
        public static implicit operator WhatsAppMessageButtonSubType(string value) => new WhatsAppMessageButtonSubType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WhatsAppMessageButtonSubType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WhatsAppMessageButtonSubType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
