// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.Messages
{
    /// <summary>
    /// Details of the message to send.
    /// Please note <see cref="NotificationContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AudioNotificationContent"/>, <see cref="DocumentNotificationContent"/>, <see cref="ImageNotificationContent"/>, <see cref="MediaNotificationContent"/>, <see cref="TemplateNotificationContent"/>, <see cref="TextNotificationContent"/> and <see cref="VideoNotificationContent"/>.
    /// </summary>
    public abstract partial class NotificationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationContent"/>. </summary>
        /// <param name="channelRegistrationId"> The Channel Registration ID for the Business Identifier. </param>
        /// <param name="to"> The native external platform user identifiers of the recipient. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="to"/> is null. </exception>
        protected NotificationContent(Guid channelRegistrationId, IEnumerable<string> to)
        {
            Argument.AssertNotNull(to, nameof(to));

            ChannelRegistrationId = channelRegistrationId;
            To = to.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="NotificationContent"/>. </summary>
        /// <param name="channelRegistrationId"> The Channel Registration ID for the Business Identifier. </param>
        /// <param name="to"> The native external platform user identifiers of the recipient. </param>
        /// <param name="kind"> The type discriminator describing a notification type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationContent(Guid channelRegistrationId, IList<string> to, CommunicationMessageKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ChannelRegistrationId = channelRegistrationId;
            To = to;
            Kind = kind;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NotificationContent"/> for deserialization. </summary>
        internal NotificationContent()
        {
        }

        /// <summary> The Channel Registration ID for the Business Identifier. </summary>
        public Guid ChannelRegistrationId { get; }
        /// <summary> The native external platform user identifiers of the recipient. </summary>
        public IList<string> To { get; }
        /// <summary> The type discriminator describing a notification type. </summary>
        internal CommunicationMessageKind Kind { get; set; }
    }
}
