// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Messages
{
    /// <summary> The type of the template parameter. </summary>
    internal readonly partial struct MessageTemplateValueKind : IEquatable<MessageTemplateValueKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageTemplateValueKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageTemplateValueKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TextValue = "text";
        private const string ImageValue = "image";
        private const string DocumentValue = "document";
        private const string VideoValue = "video";
        private const string LocationValue = "location";
        private const string QuickActionValue = "quickAction";

        /// <summary> The text template parameter type. </summary>
        public static MessageTemplateValueKind Text { get; } = new MessageTemplateValueKind(TextValue);
        /// <summary> The image template parameter type. </summary>
        public static MessageTemplateValueKind Image { get; } = new MessageTemplateValueKind(ImageValue);
        /// <summary> The document template parameter type. </summary>
        public static MessageTemplateValueKind Document { get; } = new MessageTemplateValueKind(DocumentValue);
        /// <summary> The video template parameter type. </summary>
        public static MessageTemplateValueKind Video { get; } = new MessageTemplateValueKind(VideoValue);
        /// <summary> The location template parameter type. </summary>
        public static MessageTemplateValueKind Location { get; } = new MessageTemplateValueKind(LocationValue);
        /// <summary> The quick action template parameter type. </summary>
        public static MessageTemplateValueKind QuickAction { get; } = new MessageTemplateValueKind(QuickActionValue);
        /// <summary> Determines if two <see cref="MessageTemplateValueKind"/> values are the same. </summary>
        public static bool operator ==(MessageTemplateValueKind left, MessageTemplateValueKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageTemplateValueKind"/> values are not the same. </summary>
        public static bool operator !=(MessageTemplateValueKind left, MessageTemplateValueKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageTemplateValueKind"/>. </summary>
        public static implicit operator MessageTemplateValueKind(string value) => new MessageTemplateValueKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageTemplateValueKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageTemplateValueKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
