// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Messages
{
    /// <summary> The aggregated template status. </summary>
    public readonly partial struct MessageTemplateStatus : IEquatable<MessageTemplateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageTemplateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageTemplateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApprovedValue = "approved";
        private const string RejectedValue = "rejected";
        private const string PendingValue = "pending";
        private const string PausedValue = "paused";

        /// <summary> Message template is approved. </summary>
        public static MessageTemplateStatus Approved { get; } = new MessageTemplateStatus(ApprovedValue);
        /// <summary> Message template is rejected. </summary>
        public static MessageTemplateStatus Rejected { get; } = new MessageTemplateStatus(RejectedValue);
        /// <summary> Message template is pending. </summary>
        public static MessageTemplateStatus Pending { get; } = new MessageTemplateStatus(PendingValue);
        /// <summary> Message template is paused. </summary>
        public static MessageTemplateStatus Paused { get; } = new MessageTemplateStatus(PausedValue);
        /// <summary> Determines if two <see cref="MessageTemplateStatus"/> values are the same. </summary>
        public static bool operator ==(MessageTemplateStatus left, MessageTemplateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageTemplateStatus"/> values are not the same. </summary>
        public static bool operator !=(MessageTemplateStatus left, MessageTemplateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageTemplateStatus"/>. </summary>
        public static implicit operator MessageTemplateStatus(string value) => new MessageTemplateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageTemplateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageTemplateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
