// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.Messages
{
    /// <summary> The message template's quick action value information. </summary>
    public partial class MessageTemplateQuickAction : MessageTemplateValue
    {
        /// <summary> Initializes a new instance of <see cref="MessageTemplateQuickAction"/>. </summary>
        /// <param name="name"> Template binding reference name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public MessageTemplateQuickAction(string name) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Kind = MessageTemplateValueKind.QuickAction;
        }

        /// <summary> Initializes a new instance of <see cref="MessageTemplateQuickAction"/>. </summary>
        /// <param name="name"> Template binding reference name. </param>
        /// <param name="kind"> The type discriminator describing a template parameter type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="text"> The [Optional] quick action text. </param>
        /// <param name="payload"> The [Optional] quick action payload. </param>
        internal MessageTemplateQuickAction(string name, MessageTemplateValueKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, string text, string payload) : base(name, kind, serializedAdditionalRawData)
        {
            Text = text;
            Payload = payload;
        }

        /// <summary> Initializes a new instance of <see cref="MessageTemplateQuickAction"/> for deserialization. </summary>
        internal MessageTemplateQuickAction()
        {
        }

        /// <summary> The [Optional] quick action text. </summary>
        public string Text { get; set; }
        /// <summary> The [Optional] quick action payload. </summary>
        public string Payload { get; set; }
    }
}
