// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Messages
{
    /// <summary> The type of the communication messages channel. </summary>
    internal readonly partial struct CommunicationMessagesChannel : IEquatable<CommunicationMessagesChannel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CommunicationMessagesChannel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CommunicationMessagesChannel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WhatsAppValue = "whatsApp";

        /// <summary> The WhatsApp communication messages channel type. </summary>
        public static CommunicationMessagesChannel WhatsApp { get; } = new CommunicationMessagesChannel(WhatsAppValue);
        /// <summary> Determines if two <see cref="CommunicationMessagesChannel"/> values are the same. </summary>
        public static bool operator ==(CommunicationMessagesChannel left, CommunicationMessagesChannel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CommunicationMessagesChannel"/> values are not the same. </summary>
        public static bool operator !=(CommunicationMessagesChannel left, CommunicationMessagesChannel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CommunicationMessagesChannel"/>. </summary>
        public static implicit operator CommunicationMessagesChannel(string value) => new CommunicationMessagesChannel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CommunicationMessagesChannel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CommunicationMessagesChannel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
