// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.JobRouter
{
    /// <summary> Discriminators for supported worker selector attachment types. </summary>
    public readonly partial struct WorkerSelectorAttachmentKind : IEquatable<WorkerSelectorAttachmentKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkerSelectorAttachmentKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkerSelectorAttachmentKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConditionalValue = "conditional";
        private const string PassThroughValue = "passThrough";
        private const string RuleEngineValue = "ruleEngine";
        private const string StaticValue = "static";
        private const string WeightedAllocationValue = "weightedAllocation";

        /// <summary> Discriminator value for ConditionalWorkerSelectorAttachment. </summary>
        public static WorkerSelectorAttachmentKind Conditional { get; } = new WorkerSelectorAttachmentKind(ConditionalValue);
        /// <summary> Discriminator value for PassThroughWorkerSelectorAttachment. </summary>
        public static WorkerSelectorAttachmentKind PassThrough { get; } = new WorkerSelectorAttachmentKind(PassThroughValue);
        /// <summary> Discriminator value for RuleEngineWorkerSelectorAttachment. </summary>
        public static WorkerSelectorAttachmentKind RuleEngine { get; } = new WorkerSelectorAttachmentKind(RuleEngineValue);
        /// <summary> Discriminator value for StaticWorkerSelectorAttachment. </summary>
        public static WorkerSelectorAttachmentKind Static { get; } = new WorkerSelectorAttachmentKind(StaticValue);
        /// <summary> Discriminator value for WeightedAllocationWorkerSelectorAttachment. </summary>
        public static WorkerSelectorAttachmentKind WeightedAllocation { get; } = new WorkerSelectorAttachmentKind(WeightedAllocationValue);
        /// <summary> Determines if two <see cref="WorkerSelectorAttachmentKind"/> values are the same. </summary>
        public static bool operator ==(WorkerSelectorAttachmentKind left, WorkerSelectorAttachmentKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkerSelectorAttachmentKind"/> values are not the same. </summary>
        public static bool operator !=(WorkerSelectorAttachmentKind left, WorkerSelectorAttachmentKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkerSelectorAttachmentKind"/>. </summary>
        public static implicit operator WorkerSelectorAttachmentKind(string value) => new WorkerSelectorAttachmentKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkerSelectorAttachmentKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkerSelectorAttachmentKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
